Next, we want to generate our own public/private keypair for the HTTPS comms.  We'll use the same on both the Team Server and Apache redirectors to maintain the encryption end-to-end.  Depending on your paranoia level, another option is to offload HTTPS at the redirector and forward the traffic to the Team Server (over the SSH/VPN tunnel) as HTTP.

  I own the **acmecorp.uk** domain name which I'll use for this example.  Please note that you won't be able to go through the full process of having your certificate signed by a trusted CA, because the lab is not connected to the Internet.

  

Generate a new keypair on the Team Server VM using `openssl`.  This will produce both a public certificate and private key.

ubuntu@teamserver ~> openssl req -new -newkey rsa:4096 -x509 -sha256 -days 365 -nodes -out public.crt -keyout private.key
Generating a RSA private key
.......................................................................................................................................................................................
...................................................................................++++
...........++++
writing new private key to 'private.key'
-----
You are about to be asked to enter information that will be incorporated
into your certificate request.
What you are about to enter is what is called a Distinguished Name or a DN.
There are quite a few fields but you can leave some blank
For some fields there will be a default value,
If you enter '.', the field will be left blank.
-----
Country Name (2 letter code) [AU]:UK
State or Province Name (full name) [Some-State]:London
Locality Name (eg, city) []:
Organization Name (eg, company) [Internet Widgits Pty Ltd]:ACME Corp
Organizational Unit Name (eg, section) []:
Common Name (e.g. server FQDN or YOUR name) []:acmecorp.uk
Email Address []:

  

You can put anything in the fields with the exception of the **Common Name** - this should be the public IP, or more ideally, the fully qualified domain name.  The other fields will also be visible in the certificate, so make sure they match the "disguise" for your infrastructure.

To have your certificates signed by a trusted CA, we need to generate and submit a certificate signing request (CSR).  Note that I did not supply a challenge password.

ubuntu@teamserver ~> openssl req -new -key private.key -out acme.csr
You are about to be asked to enter information that will be incorporated
into your certificate request.
What you are about to enter is what is called a Distinguished Name or a DN.
There are quite a few fields but you can leave some blank
For some fields there will be a default value,
If you enter '.', the field will be left blank.
-----
Country Name (2 letter code) [AU]:UK
State or Province Name (full name) [Some-State]:London
Locality Name (eg, city) []:
Organization Name (eg, company) [Internet Widgits Pty Ltd]:ACME Corp
Organizational Unit Name (eg, section) []:
Common Name (e.g. server FQDN or YOUR name) []:acmecorp.uk
Email Address []:

Please enter the following 'extra' attributes
to be sent with your certificate request
A challenge password []:
An optional company name []:
ubuntu@teamserver ~> head acme.csr
-----BEGIN CERTIFICATE REQUEST-----
MIIEjTCCAnUCAQAwSDELMAkGA1UEBhMCVUsxDzANBgNVBAgMBkxvbmRvbjESMBAG
A1UECgwJQUNNRSBDb3JwMRQwEgYDVQQDDAthY2VtY29ycC51azCCAiIwDQYJKoZI
hvcNAQEBBQADggIPADCCAgoCggIBAL1JVzqtAYe6AZQoqtm5wyEsY54NwlP0o/wp
PO/KctFjwxk0K3+qWIFbWScr2kpItuUqosO/HUbs/LjTxAGE4yW3Yf0NLJRJIdmU
Tu7UkJ7c+BpP29waU1HAmJ1AVIuX3jY5aAo0vw3uWseSe4kVp4QfhYOQGM80liKK
w1TQk8X77gZgNlX8p9DPP18CCe0/ejyVWWSNlDPcJ8kxVb0mitFUPIK4GKxQx50D
q7qmy+8tTitvejQsATjG41PAbJxz+m0w3FOFqUIV3PNKGtMKi+aMbXkvTwPbhsxb
W2tIO/+wY/8wf1hkVdA+LuVuloY2RwrFRrsF6qviJHPXxQRcjDUJUtJHSI41ZJ4Y
3CK95OkKwgTDPBaTXiI4mHUTgJo9v64FvNFyryzCXqaYK9gjuYKZ7wXgfGBOg4Nh

  

The most straightforward means of getting this signed is with [certbot](https://github.com/certbot/certbot).  However, note that the public IP address of the machine will be logged as having requested the certificate.

$ certbot certonly -d acmecorp.uk --apache --register-unsafely-without-email --agree-tos

  

This will produce four separate files in `/etc/letsencrypt/archive/acmecorp.uk/`.  The two that we're interested in are `fullchain.pem` and `privkey.pem`.  These need to be copied to `/etc/ssl/certs/` and `/etc/ssl/private/` respectively, then the **SSLCertificateFile** and **SSLCertificateKeyFile** lines in `/etc/apache2/sites-available/default-ssl.conf` updated.

  

   In the lab, you can just use the original `public.crt` and `private.key` files instead.  You will also need to add the following lines in Apache's default-ssl configuration:  
  

SSLProxyCheckPeerCN off

This is required to tell Apache to ignore that the SSL certificate on Cobalt Strike's HTTPS listener is self-signed.

  

Finally, restart Apache and the site will have a trusted HTTPS connection.

![[9. Generate SSL Certificates.png]]

